<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class Instance extends \Google\Collection
{
  /**
   * The server is in an unknown state.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The server is being provisioned.
   */
  public const STATE_PROVISIONING = 'PROVISIONING';
  /**
   * The server is running.
   */
  public const STATE_RUNNING = 'RUNNING';
  /**
   * The server has been deleted.
   */
  public const STATE_DELETED = 'DELETED';
  /**
   * The server is being updated.
   */
  public const STATE_UPDATING = 'UPDATING';
  /**
   * The server is starting.
   */
  public const STATE_STARTING = 'STARTING';
  /**
   * The server is stopping.
   */
  public const STATE_STOPPING = 'STOPPING';
  /**
   * The server is shutdown.
   */
  public const STATE_SHUTDOWN = 'SHUTDOWN';
  /**
   * The workload profile is in an unknown state.
   */
  public const WORKLOAD_PROFILE_WORKLOAD_PROFILE_UNSPECIFIED = 'WORKLOAD_PROFILE_UNSPECIFIED';
  /**
   * The workload profile is generic.
   */
  public const WORKLOAD_PROFILE_WORKLOAD_PROFILE_GENERIC = 'WORKLOAD_PROFILE_GENERIC';
  /**
   * The workload profile is hana.
   */
  public const WORKLOAD_PROFILE_WORKLOAD_PROFILE_HANA = 'WORKLOAD_PROFILE_HANA';
  protected $collection_key = 'volumes';
  /**
   * Output only. Create a time stamp.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. The firmware version for the instance.
   *
   * @var string
   */
  public $firmwareVersion;
  /**
   * True if you enable hyperthreading for the server, otherwise false. The
   * default value is false.
   *
   * @var bool
   */
  public $hyperthreadingEnabled;
  /**
   * Output only. An identifier for the `Instance`, generated by the backend.
   *
   * @var string
   */
  public $id;
  /**
   * Output only. True if the interactive serial console feature is enabled for
   * the instance, false otherwise. The default value is false.
   *
   * @var bool
   */
  public $interactiveSerialConsoleEnabled;
  /**
   * Optional. Name of the KMS crypto key version used to encrypt the initial
   * passwords. The key has to have ASYMMETRIC_DECRYPT purpose. Format is `proje
   * cts/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryp
   * toKeyVersions/{version}`.
   *
   * @var string
   */
  public $kmsKeyVersion;
  /**
   * Labels as key value pairs.
   *
   * @var string[]
   */
  public $labels;
  protected $logicalInterfacesType = GoogleCloudBaremetalsolutionV2LogicalInterface::class;
  protected $logicalInterfacesDataType = 'array';
  /**
   * Output only. Text field about info for logging in.
   *
   * @var string
   */
  public $loginInfo;
  protected $lunsType = Lun::class;
  protected $lunsDataType = 'array';
  /**
   * Immutable. The server type. [Available server
   * types](https://cloud.google.com/bare-metal/docs/bms-
   * planning#server_configurations)
   *
   * @var string
   */
  public $machineType;
  /**
   * Immutable. The resource name of this `Instance`. Resource names are
   * schemeless URIs that follow the conventions in
   * https://cloud.google.com/apis/design/resource_names. Format:
   * `projects/{project}/locations/{location}/instances/{instance}`
   *
   * @var string
   */
  public $name;
  /**
   * Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc.
   * Generally, the template name follows the syntax of "bond" or "nic".
   *
   * @var string
   */
  public $networkTemplate;
  protected $networksType = Network::class;
  protected $networksDataType = 'array';
  /**
   * The OS image currently installed on the server.
   *
   * @var string
   */
  public $osImage;
  /**
   * Immutable. Pod name. Pod is an independent part of infrastructure. Instance
   * can only be connected to the assets (networks, volumes) allocated in the
   * same pod.
   *
   * @var string
   */
  public $pod;
  /**
   * Optional. List of SSH Keys used during instance provisioning.
   *
   * @var string[]
   */
  public $sshKeys;
  /**
   * Output only. The state of the server.
   *
   * @var string
   */
  public $state;
  /**
   * Output only. Update a time stamp.
   *
   * @var string
   */
  public $updateTime;
  protected $volumesType = Volume::class;
  protected $volumesDataType = 'array';
  /**
   * The workload profile for the instance.
   *
   * @var string
   */
  public $workloadProfile;

  /**
   * Output only. Create a time stamp.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. The firmware version for the instance.
   *
   * @param string $firmwareVersion
   */
  public function setFirmwareVersion($firmwareVersion)
  {
    $this->firmwareVersion = $firmwareVersion;
  }
  /**
   * @return string
   */
  public function getFirmwareVersion()
  {
    return $this->firmwareVersion;
  }
  /**
   * True if you enable hyperthreading for the server, otherwise false. The
   * default value is false.
   *
   * @param bool $hyperthreadingEnabled
   */
  public function setHyperthreadingEnabled($hyperthreadingEnabled)
  {
    $this->hyperthreadingEnabled = $hyperthreadingEnabled;
  }
  /**
   * @return bool
   */
  public function getHyperthreadingEnabled()
  {
    return $this->hyperthreadingEnabled;
  }
  /**
   * Output only. An identifier for the `Instance`, generated by the backend.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. True if the interactive serial console feature is enabled for
   * the instance, false otherwise. The default value is false.
   *
   * @param bool $interactiveSerialConsoleEnabled
   */
  public function setInteractiveSerialConsoleEnabled($interactiveSerialConsoleEnabled)
  {
    $this->interactiveSerialConsoleEnabled = $interactiveSerialConsoleEnabled;
  }
  /**
   * @return bool
   */
  public function getInteractiveSerialConsoleEnabled()
  {
    return $this->interactiveSerialConsoleEnabled;
  }
  /**
   * Optional. Name of the KMS crypto key version used to encrypt the initial
   * passwords. The key has to have ASYMMETRIC_DECRYPT purpose. Format is `proje
   * cts/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryp
   * toKeyVersions/{version}`.
   *
   * @param string $kmsKeyVersion
   */
  public function setKmsKeyVersion($kmsKeyVersion)
  {
    $this->kmsKeyVersion = $kmsKeyVersion;
  }
  /**
   * @return string
   */
  public function getKmsKeyVersion()
  {
    return $this->kmsKeyVersion;
  }
  /**
   * Labels as key value pairs.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * List of logical interfaces for the instance. The number of logical
   * interfaces will be the same as number of hardware bond/nic on the chosen
   * network template. For the non-multivlan configurations (for eg, existing
   * servers) that use existing default network template (bondaa-bondaa), both
   * the Instance.networks field and the Instance.logical_interfaces fields will
   * be filled to ensure backward compatibility. For the others, only
   * Instance.logical_interfaces will be filled.
   *
   * @param GoogleCloudBaremetalsolutionV2LogicalInterface[] $logicalInterfaces
   */
  public function setLogicalInterfaces($logicalInterfaces)
  {
    $this->logicalInterfaces = $logicalInterfaces;
  }
  /**
   * @return GoogleCloudBaremetalsolutionV2LogicalInterface[]
   */
  public function getLogicalInterfaces()
  {
    return $this->logicalInterfaces;
  }
  /**
   * Output only. Text field about info for logging in.
   *
   * @param string $loginInfo
   */
  public function setLoginInfo($loginInfo)
  {
    $this->loginInfo = $loginInfo;
  }
  /**
   * @return string
   */
  public function getLoginInfo()
  {
    return $this->loginInfo;
  }
  /**
   * Immutable. List of LUNs associated with this server.
   *
   * @param Lun[] $luns
   */
  public function setLuns($luns)
  {
    $this->luns = $luns;
  }
  /**
   * @return Lun[]
   */
  public function getLuns()
  {
    return $this->luns;
  }
  /**
   * Immutable. The server type. [Available server
   * types](https://cloud.google.com/bare-metal/docs/bms-
   * planning#server_configurations)
   *
   * @param string $machineType
   */
  public function setMachineType($machineType)
  {
    $this->machineType = $machineType;
  }
  /**
   * @return string
   */
  public function getMachineType()
  {
    return $this->machineType;
  }
  /**
   * Immutable. The resource name of this `Instance`. Resource names are
   * schemeless URIs that follow the conventions in
   * https://cloud.google.com/apis/design/resource_names. Format:
   * `projects/{project}/locations/{location}/instances/{instance}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Instance network template name. For eg, bondaa-bondaa, bondab-nic, etc.
   * Generally, the template name follows the syntax of "bond" or "nic".
   *
   * @param string $networkTemplate
   */
  public function setNetworkTemplate($networkTemplate)
  {
    $this->networkTemplate = $networkTemplate;
  }
  /**
   * @return string
   */
  public function getNetworkTemplate()
  {
    return $this->networkTemplate;
  }
  /**
   * Output only. List of networks associated with this server.
   *
   * @param Network[] $networks
   */
  public function setNetworks($networks)
  {
    $this->networks = $networks;
  }
  /**
   * @return Network[]
   */
  public function getNetworks()
  {
    return $this->networks;
  }
  /**
   * The OS image currently installed on the server.
   *
   * @param string $osImage
   */
  public function setOsImage($osImage)
  {
    $this->osImage = $osImage;
  }
  /**
   * @return string
   */
  public function getOsImage()
  {
    return $this->osImage;
  }
  /**
   * Immutable. Pod name. Pod is an independent part of infrastructure. Instance
   * can only be connected to the assets (networks, volumes) allocated in the
   * same pod.
   *
   * @param string $pod
   */
  public function setPod($pod)
  {
    $this->pod = $pod;
  }
  /**
   * @return string
   */
  public function getPod()
  {
    return $this->pod;
  }
  /**
   * Optional. List of SSH Keys used during instance provisioning.
   *
   * @param string[] $sshKeys
   */
  public function setSshKeys($sshKeys)
  {
    $this->sshKeys = $sshKeys;
  }
  /**
   * @return string[]
   */
  public function getSshKeys()
  {
    return $this->sshKeys;
  }
  /**
   * Output only. The state of the server.
   *
   * Accepted values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, DELETED,
   * UPDATING, STARTING, STOPPING, SHUTDOWN
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Output only. Update a time stamp.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Input only. List of Volumes to attach to this Instance on creation. This
   * field won't be populated in Get/List responses.
   *
   * @param Volume[] $volumes
   */
  public function setVolumes($volumes)
  {
    $this->volumes = $volumes;
  }
  /**
   * @return Volume[]
   */
  public function getVolumes()
  {
    return $this->volumes;
  }
  /**
   * The workload profile for the instance.
   *
   * Accepted values: WORKLOAD_PROFILE_UNSPECIFIED, WORKLOAD_PROFILE_GENERIC,
   * WORKLOAD_PROFILE_HANA
   *
   * @param self::WORKLOAD_PROFILE_* $workloadProfile
   */
  public function setWorkloadProfile($workloadProfile)
  {
    $this->workloadProfile = $workloadProfile;
  }
  /**
   * @return self::WORKLOAD_PROFILE_*
   */
  public function getWorkloadProfile()
  {
    return $this->workloadProfile;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Instance::class, 'Google_Service_Baremetalsolution_Instance');
