<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class Lun extends \Google\Collection
{
  /**
   * Server has no OS specified.
   */
  public const MULTIPROTOCOL_TYPE_MULTIPROTOCOL_TYPE_UNSPECIFIED = 'MULTIPROTOCOL_TYPE_UNSPECIFIED';
  /**
   * Server with Linux OS.
   */
  public const MULTIPROTOCOL_TYPE_LINUX = 'LINUX';
  /**
   * The LUN is in an unknown state.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The LUN is being created.
   */
  public const STATE_CREATING = 'CREATING';
  /**
   * The LUN is being updated.
   */
  public const STATE_UPDATING = 'UPDATING';
  /**
   * The LUN is ready for use.
   */
  public const STATE_READY = 'READY';
  /**
   * The LUN has been requested to be deleted.
   */
  public const STATE_DELETING = 'DELETING';
  /**
   * The LUN is in cool off state. It will be deleted after `expire_time`.
   */
  public const STATE_COOL_OFF = 'COOL_OFF';
  /**
   * The storage type for this LUN is unknown.
   */
  public const STORAGE_TYPE_STORAGE_TYPE_UNSPECIFIED = 'STORAGE_TYPE_UNSPECIFIED';
  /**
   * This storage type for this LUN is SSD.
   */
  public const STORAGE_TYPE_SSD = 'SSD';
  /**
   * This storage type for this LUN is HDD.
   */
  public const STORAGE_TYPE_HDD = 'HDD';
  protected $collection_key = 'instances';
  /**
   * Display if this LUN is a boot LUN.
   *
   * @var bool
   */
  public $bootLun;
  /**
   * Output only. Time after which LUN will be fully deleted. It is filled only
   * for LUNs in COOL_OFF state.
   *
   * @var string
   */
  public $expireTime;
  /**
   * An identifier for the LUN, generated by the backend.
   *
   * @var string
   */
  public $id;
  /**
   * Output only. Instances this Lun is attached to.
   *
   * @var string[]
   */
  public $instances;
  /**
   * The LUN multiprotocol type ensures the characteristics of the LUN are
   * optimized for each operating system.
   *
   * @var string
   */
  public $multiprotocolType;
  /**
   * Output only. The name of the LUN.
   *
   * @var string
   */
  public $name;
  /**
   * Display if this LUN can be shared between multiple physical servers.
   *
   * @var bool
   */
  public $shareable;
  /**
   * The size of this LUN, in GiB.
   *
   * @var string
   */
  public $sizeGb;
  /**
   * The state of this storage volume.
   *
   * @var string
   */
  public $state;
  /**
   * The storage type for this LUN.
   *
   * @var string
   */
  public $storageType;
  /**
   * Display the storage volume for this LUN.
   *
   * @var string
   */
  public $storageVolume;
  /**
   * The WWID for this LUN.
   *
   * @var string
   */
  public $wwid;

  /**
   * Display if this LUN is a boot LUN.
   *
   * @param bool $bootLun
   */
  public function setBootLun($bootLun)
  {
    $this->bootLun = $bootLun;
  }
  /**
   * @return bool
   */
  public function getBootLun()
  {
    return $this->bootLun;
  }
  /**
   * Output only. Time after which LUN will be fully deleted. It is filled only
   * for LUNs in COOL_OFF state.
   *
   * @param string $expireTime
   */
  public function setExpireTime($expireTime)
  {
    $this->expireTime = $expireTime;
  }
  /**
   * @return string
   */
  public function getExpireTime()
  {
    return $this->expireTime;
  }
  /**
   * An identifier for the LUN, generated by the backend.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. Instances this Lun is attached to.
   *
   * @param string[] $instances
   */
  public function setInstances($instances)
  {
    $this->instances = $instances;
  }
  /**
   * @return string[]
   */
  public function getInstances()
  {
    return $this->instances;
  }
  /**
   * The LUN multiprotocol type ensures the characteristics of the LUN are
   * optimized for each operating system.
   *
   * Accepted values: MULTIPROTOCOL_TYPE_UNSPECIFIED, LINUX
   *
   * @param self::MULTIPROTOCOL_TYPE_* $multiprotocolType
   */
  public function setMultiprotocolType($multiprotocolType)
  {
    $this->multiprotocolType = $multiprotocolType;
  }
  /**
   * @return self::MULTIPROTOCOL_TYPE_*
   */
  public function getMultiprotocolType()
  {
    return $this->multiprotocolType;
  }
  /**
   * Output only. The name of the LUN.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Display if this LUN can be shared between multiple physical servers.
   *
   * @param bool $shareable
   */
  public function setShareable($shareable)
  {
    $this->shareable = $shareable;
  }
  /**
   * @return bool
   */
  public function getShareable()
  {
    return $this->shareable;
  }
  /**
   * The size of this LUN, in GiB.
   *
   * @param string $sizeGb
   */
  public function setSizeGb($sizeGb)
  {
    $this->sizeGb = $sizeGb;
  }
  /**
   * @return string
   */
  public function getSizeGb()
  {
    return $this->sizeGb;
  }
  /**
   * The state of this storage volume.
   *
   * Accepted values: STATE_UNSPECIFIED, CREATING, UPDATING, READY, DELETING,
   * COOL_OFF
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * The storage type for this LUN.
   *
   * Accepted values: STORAGE_TYPE_UNSPECIFIED, SSD, HDD
   *
   * @param self::STORAGE_TYPE_* $storageType
   */
  public function setStorageType($storageType)
  {
    $this->storageType = $storageType;
  }
  /**
   * @return self::STORAGE_TYPE_*
   */
  public function getStorageType()
  {
    return $this->storageType;
  }
  /**
   * Display the storage volume for this LUN.
   *
   * @param string $storageVolume
   */
  public function setStorageVolume($storageVolume)
  {
    $this->storageVolume = $storageVolume;
  }
  /**
   * @return string
   */
  public function getStorageVolume()
  {
    return $this->storageVolume;
  }
  /**
   * The WWID for this LUN.
   *
   * @param string $wwid
   */
  public function setWwid($wwid)
  {
    $this->wwid = $wwid;
  }
  /**
   * @return string
   */
  public function getWwid()
  {
    return $this->wwid;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Lun::class, 'Google_Service_Baremetalsolution_Lun');
