<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDeploy;

class BuildArtifact extends \Google\Model
{
  /**
   * Optional. Image name in Skaffold configuration.
   *
   * @var string
   */
  public $image;
  /**
   * Optional. Image tag to use. This will generally be the full path to an
   * image, such as "gcr.io/my-project/busybox:1.2.3" or "gcr.io/my-
   * project/busybox@sha256:abc123".
   *
   * @var string
   */
  public $tag;

  /**
   * Optional. Image name in Skaffold configuration.
   *
   * @param string $image
   */
  public function setImage($image)
  {
    $this->image = $image;
  }
  /**
   * @return string
   */
  public function getImage()
  {
    return $this->image;
  }
  /**
   * Optional. Image tag to use. This will generally be the full path to an
   * image, such as "gcr.io/my-project/busybox:1.2.3" or "gcr.io/my-
   * project/busybox@sha256:abc123".
   *
   * @param string $tag
   */
  public function setTag($tag)
  {
    $this->tag = $tag;
  }
  /**
   * @return string
   */
  public function getTag()
  {
    return $this->tag;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BuildArtifact::class, 'Google_Service_CloudDeploy_BuildArtifact');
