<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataCatalog;

class GoogleCloudDatacatalogV1EntryGroup extends \Google\Model
{
  protected $dataCatalogTimestampsType = GoogleCloudDatacatalogV1SystemTimestamps::class;
  protected $dataCatalogTimestampsDataType = '';
  /**
   * Entry group description. Can consist of several sentences or paragraphs
   * that describe the entry group contents. Default value is an empty string.
   *
   * @var string
   */
  public $description;
  /**
   * A short name to identify the entry group, for example, "analytics data -
   * jan 2011". Default value is an empty string.
   *
   * @var string
   */
  public $displayName;
  /**
   * Identifier. The resource name of the entry group in URL format. Note: The
   * entry group itself and its child resources might not be stored in the
   * location specified in its name.
   *
   * @var string
   */
  public $name;
  /**
   * Optional. When set to [true], it means DataCatalog EntryGroup was
   * transferred to Dataplex Universal Catalog. It makes EntryGroup and its
   * Entries to be read-only in DataCatalog. However, new Tags on EntryGroup and
   * its Entries can be created. After setting the flag to [true] it cannot be
   * unset.
   *
   * @var bool
   */
  public $transferredToDataplex;

  /**
   * Output only. Timestamps of the entry group. Default value is empty.
   *
   * @param GoogleCloudDatacatalogV1SystemTimestamps $dataCatalogTimestamps
   */
  public function setDataCatalogTimestamps(GoogleCloudDatacatalogV1SystemTimestamps $dataCatalogTimestamps)
  {
    $this->dataCatalogTimestamps = $dataCatalogTimestamps;
  }
  /**
   * @return GoogleCloudDatacatalogV1SystemTimestamps
   */
  public function getDataCatalogTimestamps()
  {
    return $this->dataCatalogTimestamps;
  }
  /**
   * Entry group description. Can consist of several sentences or paragraphs
   * that describe the entry group contents. Default value is an empty string.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * A short name to identify the entry group, for example, "analytics data -
   * jan 2011". Default value is an empty string.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Identifier. The resource name of the entry group in URL format. Note: The
   * entry group itself and its child resources might not be stored in the
   * location specified in its name.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. When set to [true], it means DataCatalog EntryGroup was
   * transferred to Dataplex Universal Catalog. It makes EntryGroup and its
   * Entries to be read-only in DataCatalog. However, new Tags on EntryGroup and
   * its Entries can be created. After setting the flag to [true] it cannot be
   * unset.
   *
   * @param bool $transferredToDataplex
   */
  public function setTransferredToDataplex($transferredToDataplex)
  {
    $this->transferredToDataplex = $transferredToDataplex;
  }
  /**
   * @return bool
   */
  public function getTransferredToDataplex()
  {
    return $this->transferredToDataplex;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDatacatalogV1EntryGroup::class, 'Google_Service_DataCatalog_GoogleCloudDatacatalogV1EntryGroup');
