<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessLodging;

class Services extends \Google\Collection
{
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const BAGGAGE_STORAGE_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const BAGGAGE_STORAGE_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const BAGGAGE_STORAGE_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const BAGGAGE_STORAGE_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const CONCIERGE_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const CONCIERGE_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const CONCIERGE_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const CONCIERGE_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const CONVENIENCE_STORE_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const CONVENIENCE_STORE_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const CONVENIENCE_STORE_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const CONVENIENCE_STORE_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const CURRENCY_EXCHANGE_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const CURRENCY_EXCHANGE_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const CURRENCY_EXCHANGE_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const CURRENCY_EXCHANGE_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const ELEVATOR_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const ELEVATOR_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const ELEVATOR_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const ELEVATOR_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const FRONT_DESK_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const FRONT_DESK_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const FRONT_DESK_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const FRONT_DESK_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const FULL_SERVICE_LAUNDRY_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const FULL_SERVICE_LAUNDRY_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const FULL_SERVICE_LAUNDRY_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const FULL_SERVICE_LAUNDRY_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const GIFT_SHOP_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const GIFT_SHOP_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const GIFT_SHOP_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const GIFT_SHOP_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const SELF_SERVICE_LAUNDRY_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const SELF_SERVICE_LAUNDRY_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const SELF_SERVICE_LAUNDRY_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const SELF_SERVICE_LAUNDRY_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const SOCIAL_HOUR_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const SOCIAL_HOUR_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const SOCIAL_HOUR_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const SOCIAL_HOUR_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const TWENTY_FOUR_HOUR_FRONT_DESK_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const TWENTY_FOUR_HOUR_FRONT_DESK_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const TWENTY_FOUR_HOUR_FRONT_DESK_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const TWENTY_FOUR_HOUR_FRONT_DESK_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  /**
   * Default unspecified exception. Use this only if a more specific exception
   * does not match.
   */
  public const WAKE_UP_CALLS_EXCEPTION_EXCEPTION_UNSPECIFIED = 'EXCEPTION_UNSPECIFIED';
  /**
   * Amenity or service is unavailable due to ongoing work orders.
   */
  public const WAKE_UP_CALLS_EXCEPTION_UNDER_CONSTRUCTION = 'UNDER_CONSTRUCTION';
  /**
   * Amenity or service availability is seasonal.
   */
  public const WAKE_UP_CALLS_EXCEPTION_DEPENDENT_ON_SEASON = 'DEPENDENT_ON_SEASON';
  /**
   * Amenity or service availability depends on the day of the week.
   */
  public const WAKE_UP_CALLS_EXCEPTION_DEPENDENT_ON_DAY_OF_WEEK = 'DEPENDENT_ON_DAY_OF_WEEK';
  protected $collection_key = 'languagesSpoken';
  /**
   * Baggage storage. A provision for guests to leave their bags at the hotel
   * when they arrive for their stay before the official check-in time. May or
   * may not apply for guests who wish to leave their bags after check-out and
   * before departing the locale. Also known as bag dropoff.
   *
   * @var bool
   */
  public $baggageStorage;
  /**
   * Baggage storage exception.
   *
   * @var string
   */
  public $baggageStorageException;
  /**
   * Concierge. Hotel staff member(s) responsible for facilitating an easy,
   * comfortable stay through making reservations for meals, sourcing theater
   * tickets, arranging tours, finding a doctor, making recommendations, and
   * answering questions.
   *
   * @var bool
   */
  public $concierge;
  /**
   * Concierge exception.
   *
   * @var string
   */
  public $conciergeException;
  /**
   * Convenience store. A shop at the hotel primarily selling snacks, drinks,
   * non-prescription medicines, health and beauty aids, magazines and
   * newspapers.
   *
   * @var bool
   */
  public $convenienceStore;
  /**
   * Convenience store exception.
   *
   * @var string
   */
  public $convenienceStoreException;
  /**
   * Currency exchange. A staff member or automated machine tasked with the
   * transaction of providing the native currency of the hotel's locale in
   * exchange for the foreign currency provided by a guest.
   *
   * @var bool
   */
  public $currencyExchange;
  /**
   * Currency exchange exception.
   *
   * @var string
   */
  public $currencyExchangeException;
  /**
   * Elevator. A passenger elevator that transports guests from one story to
   * another. Also known as lift.
   *
   * @var bool
   */
  public $elevator;
  /**
   * Elevator exception.
   *
   * @var string
   */
  public $elevatorException;
  /**
   * Front desk. A counter or desk in the lobby or the immediate interior of the
   * hotel where a member of the staff greets guests and processes the
   * information related to their stay (including check-in and check-out). May
   * or may not be manned and open 24/7.
   *
   * @var bool
   */
  public $frontDesk;
  /**
   * Front desk exception.
   *
   * @var string
   */
  public $frontDeskException;
  /**
   * Full service laundry. Laundry and dry cleaning facilitated and handled by
   * the hotel on behalf of the guest. Does not include the provision for guests
   * to do their own laundry in on-site machines.
   *
   * @var bool
   */
  public $fullServiceLaundry;
  /**
   * Full service laundry exception.
   *
   * @var string
   */
  public $fullServiceLaundryException;
  /**
   * Gift shop. An on-site store primarily selling souvenirs, mementos and other
   * gift items. May or may not also sell sundries, magazines and newspapers,
   * clothing, or snacks.
   *
   * @var bool
   */
  public $giftShop;
  /**
   * Gift shop exception.
   *
   * @var string
   */
  public $giftShopException;
  protected $languagesSpokenType = LanguageSpoken::class;
  protected $languagesSpokenDataType = 'array';
  /**
   * Self service laundry. On-site clothes washers and dryers accessible to
   * guests for the purpose of washing and drying their own clothes. May or may
   * not require payment to use the machines.
   *
   * @var bool
   */
  public $selfServiceLaundry;
  /**
   * Self service laundry exception.
   *
   * @var string
   */
  public $selfServiceLaundryException;
  /**
   * Social hour. A reception with complimentary soft drinks, tea, coffee, wine
   * and/or cocktails in the afternoon or evening. Can be hosted by hotel staff
   * or guests may serve themselves. Also known as wine hour. The availability
   * of coffee/tea in the lobby throughout the day does not constitute a social
   * or wine hour.
   *
   * @var bool
   */
  public $socialHour;
  /**
   * Social hour exception.
   *
   * @var string
   */
  public $socialHourException;
  /**
   * 24hr front desk. Front desk is staffed 24 hours a day.
   *
   * @var bool
   */
  public $twentyFourHourFrontDesk;
  /**
   * 24hr front desk exception.
   *
   * @var string
   */
  public $twentyFourHourFrontDeskException;
  /**
   * Wake up calls. By direction of the guest, a hotel staff member will phone
   * the guest unit at the requested hour. Also known as morning call.
   *
   * @var bool
   */
  public $wakeUpCalls;
  /**
   * Wake up calls exception.
   *
   * @var string
   */
  public $wakeUpCallsException;

  /**
   * Baggage storage. A provision for guests to leave their bags at the hotel
   * when they arrive for their stay before the official check-in time. May or
   * may not apply for guests who wish to leave their bags after check-out and
   * before departing the locale. Also known as bag dropoff.
   *
   * @param bool $baggageStorage
   */
  public function setBaggageStorage($baggageStorage)
  {
    $this->baggageStorage = $baggageStorage;
  }
  /**
   * @return bool
   */
  public function getBaggageStorage()
  {
    return $this->baggageStorage;
  }
  /**
   * Baggage storage exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::BAGGAGE_STORAGE_EXCEPTION_* $baggageStorageException
   */
  public function setBaggageStorageException($baggageStorageException)
  {
    $this->baggageStorageException = $baggageStorageException;
  }
  /**
   * @return self::BAGGAGE_STORAGE_EXCEPTION_*
   */
  public function getBaggageStorageException()
  {
    return $this->baggageStorageException;
  }
  /**
   * Concierge. Hotel staff member(s) responsible for facilitating an easy,
   * comfortable stay through making reservations for meals, sourcing theater
   * tickets, arranging tours, finding a doctor, making recommendations, and
   * answering questions.
   *
   * @param bool $concierge
   */
  public function setConcierge($concierge)
  {
    $this->concierge = $concierge;
  }
  /**
   * @return bool
   */
  public function getConcierge()
  {
    return $this->concierge;
  }
  /**
   * Concierge exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::CONCIERGE_EXCEPTION_* $conciergeException
   */
  public function setConciergeException($conciergeException)
  {
    $this->conciergeException = $conciergeException;
  }
  /**
   * @return self::CONCIERGE_EXCEPTION_*
   */
  public function getConciergeException()
  {
    return $this->conciergeException;
  }
  /**
   * Convenience store. A shop at the hotel primarily selling snacks, drinks,
   * non-prescription medicines, health and beauty aids, magazines and
   * newspapers.
   *
   * @param bool $convenienceStore
   */
  public function setConvenienceStore($convenienceStore)
  {
    $this->convenienceStore = $convenienceStore;
  }
  /**
   * @return bool
   */
  public function getConvenienceStore()
  {
    return $this->convenienceStore;
  }
  /**
   * Convenience store exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::CONVENIENCE_STORE_EXCEPTION_* $convenienceStoreException
   */
  public function setConvenienceStoreException($convenienceStoreException)
  {
    $this->convenienceStoreException = $convenienceStoreException;
  }
  /**
   * @return self::CONVENIENCE_STORE_EXCEPTION_*
   */
  public function getConvenienceStoreException()
  {
    return $this->convenienceStoreException;
  }
  /**
   * Currency exchange. A staff member or automated machine tasked with the
   * transaction of providing the native currency of the hotel's locale in
   * exchange for the foreign currency provided by a guest.
   *
   * @param bool $currencyExchange
   */
  public function setCurrencyExchange($currencyExchange)
  {
    $this->currencyExchange = $currencyExchange;
  }
  /**
   * @return bool
   */
  public function getCurrencyExchange()
  {
    return $this->currencyExchange;
  }
  /**
   * Currency exchange exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::CURRENCY_EXCHANGE_EXCEPTION_* $currencyExchangeException
   */
  public function setCurrencyExchangeException($currencyExchangeException)
  {
    $this->currencyExchangeException = $currencyExchangeException;
  }
  /**
   * @return self::CURRENCY_EXCHANGE_EXCEPTION_*
   */
  public function getCurrencyExchangeException()
  {
    return $this->currencyExchangeException;
  }
  /**
   * Elevator. A passenger elevator that transports guests from one story to
   * another. Also known as lift.
   *
   * @param bool $elevator
   */
  public function setElevator($elevator)
  {
    $this->elevator = $elevator;
  }
  /**
   * @return bool
   */
  public function getElevator()
  {
    return $this->elevator;
  }
  /**
   * Elevator exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::ELEVATOR_EXCEPTION_* $elevatorException
   */
  public function setElevatorException($elevatorException)
  {
    $this->elevatorException = $elevatorException;
  }
  /**
   * @return self::ELEVATOR_EXCEPTION_*
   */
  public function getElevatorException()
  {
    return $this->elevatorException;
  }
  /**
   * Front desk. A counter or desk in the lobby or the immediate interior of the
   * hotel where a member of the staff greets guests and processes the
   * information related to their stay (including check-in and check-out). May
   * or may not be manned and open 24/7.
   *
   * @param bool $frontDesk
   */
  public function setFrontDesk($frontDesk)
  {
    $this->frontDesk = $frontDesk;
  }
  /**
   * @return bool
   */
  public function getFrontDesk()
  {
    return $this->frontDesk;
  }
  /**
   * Front desk exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::FRONT_DESK_EXCEPTION_* $frontDeskException
   */
  public function setFrontDeskException($frontDeskException)
  {
    $this->frontDeskException = $frontDeskException;
  }
  /**
   * @return self::FRONT_DESK_EXCEPTION_*
   */
  public function getFrontDeskException()
  {
    return $this->frontDeskException;
  }
  /**
   * Full service laundry. Laundry and dry cleaning facilitated and handled by
   * the hotel on behalf of the guest. Does not include the provision for guests
   * to do their own laundry in on-site machines.
   *
   * @param bool $fullServiceLaundry
   */
  public function setFullServiceLaundry($fullServiceLaundry)
  {
    $this->fullServiceLaundry = $fullServiceLaundry;
  }
  /**
   * @return bool
   */
  public function getFullServiceLaundry()
  {
    return $this->fullServiceLaundry;
  }
  /**
   * Full service laundry exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::FULL_SERVICE_LAUNDRY_EXCEPTION_* $fullServiceLaundryException
   */
  public function setFullServiceLaundryException($fullServiceLaundryException)
  {
    $this->fullServiceLaundryException = $fullServiceLaundryException;
  }
  /**
   * @return self::FULL_SERVICE_LAUNDRY_EXCEPTION_*
   */
  public function getFullServiceLaundryException()
  {
    return $this->fullServiceLaundryException;
  }
  /**
   * Gift shop. An on-site store primarily selling souvenirs, mementos and other
   * gift items. May or may not also sell sundries, magazines and newspapers,
   * clothing, or snacks.
   *
   * @param bool $giftShop
   */
  public function setGiftShop($giftShop)
  {
    $this->giftShop = $giftShop;
  }
  /**
   * @return bool
   */
  public function getGiftShop()
  {
    return $this->giftShop;
  }
  /**
   * Gift shop exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::GIFT_SHOP_EXCEPTION_* $giftShopException
   */
  public function setGiftShopException($giftShopException)
  {
    $this->giftShopException = $giftShopException;
  }
  /**
   * @return self::GIFT_SHOP_EXCEPTION_*
   */
  public function getGiftShopException()
  {
    return $this->giftShopException;
  }
  /**
   * Languages spoken by at least one staff member.
   *
   * @param LanguageSpoken[] $languagesSpoken
   */
  public function setLanguagesSpoken($languagesSpoken)
  {
    $this->languagesSpoken = $languagesSpoken;
  }
  /**
   * @return LanguageSpoken[]
   */
  public function getLanguagesSpoken()
  {
    return $this->languagesSpoken;
  }
  /**
   * Self service laundry. On-site clothes washers and dryers accessible to
   * guests for the purpose of washing and drying their own clothes. May or may
   * not require payment to use the machines.
   *
   * @param bool $selfServiceLaundry
   */
  public function setSelfServiceLaundry($selfServiceLaundry)
  {
    $this->selfServiceLaundry = $selfServiceLaundry;
  }
  /**
   * @return bool
   */
  public function getSelfServiceLaundry()
  {
    return $this->selfServiceLaundry;
  }
  /**
   * Self service laundry exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::SELF_SERVICE_LAUNDRY_EXCEPTION_* $selfServiceLaundryException
   */
  public function setSelfServiceLaundryException($selfServiceLaundryException)
  {
    $this->selfServiceLaundryException = $selfServiceLaundryException;
  }
  /**
   * @return self::SELF_SERVICE_LAUNDRY_EXCEPTION_*
   */
  public function getSelfServiceLaundryException()
  {
    return $this->selfServiceLaundryException;
  }
  /**
   * Social hour. A reception with complimentary soft drinks, tea, coffee, wine
   * and/or cocktails in the afternoon or evening. Can be hosted by hotel staff
   * or guests may serve themselves. Also known as wine hour. The availability
   * of coffee/tea in the lobby throughout the day does not constitute a social
   * or wine hour.
   *
   * @param bool $socialHour
   */
  public function setSocialHour($socialHour)
  {
    $this->socialHour = $socialHour;
  }
  /**
   * @return bool
   */
  public function getSocialHour()
  {
    return $this->socialHour;
  }
  /**
   * Social hour exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::SOCIAL_HOUR_EXCEPTION_* $socialHourException
   */
  public function setSocialHourException($socialHourException)
  {
    $this->socialHourException = $socialHourException;
  }
  /**
   * @return self::SOCIAL_HOUR_EXCEPTION_*
   */
  public function getSocialHourException()
  {
    return $this->socialHourException;
  }
  /**
   * 24hr front desk. Front desk is staffed 24 hours a day.
   *
   * @param bool $twentyFourHourFrontDesk
   */
  public function setTwentyFourHourFrontDesk($twentyFourHourFrontDesk)
  {
    $this->twentyFourHourFrontDesk = $twentyFourHourFrontDesk;
  }
  /**
   * @return bool
   */
  public function getTwentyFourHourFrontDesk()
  {
    return $this->twentyFourHourFrontDesk;
  }
  /**
   * 24hr front desk exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::TWENTY_FOUR_HOUR_FRONT_DESK_EXCEPTION_* $twentyFourHourFrontDeskException
   */
  public function setTwentyFourHourFrontDeskException($twentyFourHourFrontDeskException)
  {
    $this->twentyFourHourFrontDeskException = $twentyFourHourFrontDeskException;
  }
  /**
   * @return self::TWENTY_FOUR_HOUR_FRONT_DESK_EXCEPTION_*
   */
  public function getTwentyFourHourFrontDeskException()
  {
    return $this->twentyFourHourFrontDeskException;
  }
  /**
   * Wake up calls. By direction of the guest, a hotel staff member will phone
   * the guest unit at the requested hour. Also known as morning call.
   *
   * @param bool $wakeUpCalls
   */
  public function setWakeUpCalls($wakeUpCalls)
  {
    $this->wakeUpCalls = $wakeUpCalls;
  }
  /**
   * @return bool
   */
  public function getWakeUpCalls()
  {
    return $this->wakeUpCalls;
  }
  /**
   * Wake up calls exception.
   *
   * Accepted values: EXCEPTION_UNSPECIFIED, UNDER_CONSTRUCTION,
   * DEPENDENT_ON_SEASON, DEPENDENT_ON_DAY_OF_WEEK
   *
   * @param self::WAKE_UP_CALLS_EXCEPTION_* $wakeUpCallsException
   */
  public function setWakeUpCallsException($wakeUpCallsException)
  {
    $this->wakeUpCallsException = $wakeUpCallsException;
  }
  /**
   * @return self::WAKE_UP_CALLS_EXCEPTION_*
   */
  public function getWakeUpCallsException()
  {
    return $this->wakeUpCallsException;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Services::class, 'Google_Service_MyBusinessLodging_Services');
