<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessQA;

class ListQuestionsResponse extends \Google\Collection
{
  protected $collection_key = 'questions';
  /**
   * If the number of questions exceeds the requested max page size, this field
   * is populated with a token to fetch the next page of questions on a
   * subsequent call. If there are no more questions, this field is not present
   * in the response.
   *
   * @var string
   */
  public $nextPageToken;
  protected $questionsType = Question::class;
  protected $questionsDataType = 'array';
  /**
   * The total number of questions posted for this location across all pages.
   *
   * @var int
   */
  public $totalSize;

  /**
   * If the number of questions exceeds the requested max page size, this field
   * is populated with a token to fetch the next page of questions on a
   * subsequent call. If there are no more questions, this field is not present
   * in the response.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * The requested questions,
   *
   * @param Question[] $questions
   */
  public function setQuestions($questions)
  {
    $this->questions = $questions;
  }
  /**
   * @return Question[]
   */
  public function getQuestions()
  {
    return $this->questions;
  }
  /**
   * The total number of questions posted for this location across all pages.
   *
   * @param int $totalSize
   */
  public function setTotalSize($totalSize)
  {
    $this->totalSize = $totalSize;
  }
  /**
   * @return int
   */
  public function getTotalSize()
  {
    return $this->totalSize;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListQuestionsResponse::class, 'Google_Service_MyBusinessQA_ListQuestionsResponse');
