<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkServices;

class WasmPlugin extends \Google\Collection
{
  protected $collection_key = 'usedBy';
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Optional. A human-readable description of the resource.
   *
   * @var string
   */
  public $description;
  /**
   * Optional. Set of labels associated with the `WasmPlugin` resource. The
   * format must comply with [the following
   * requirements](/compute/docs/labeling-resources#requirements).
   *
   * @var string[]
   */
  public $labels;
  protected $logConfigType = WasmPluginLogConfig::class;
  protected $logConfigDataType = '';
  /**
   * Optional. The ID of the `WasmPluginVersion` resource that is the currently
   * serving one. The version referred to must be a child of this `WasmPlugin`
   * resource.
   *
   * @var string
   */
  public $mainVersionId;
  /**
   * Identifier. Name of the `WasmPlugin` resource in the following format:
   * `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}`.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. The timestamp when the resource was updated.
   *
   * @var string
   */
  public $updateTime;
  protected $usedByType = WasmPluginUsedBy::class;
  protected $usedByDataType = 'array';
  protected $versionsType = WasmPluginVersionDetails::class;
  protected $versionsDataType = 'map';

  /**
   * Output only. The timestamp when the resource was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. A human-readable description of the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Optional. Set of labels associated with the `WasmPlugin` resource. The
   * format must comply with [the following
   * requirements](/compute/docs/labeling-resources#requirements).
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Optional. Specifies the logging options for the activity performed by this
   * plugin. If logging is enabled, plugin logs are exported to Cloud Logging.
   * Note that the settings relate to the logs generated by using logging
   * statements in your Wasm code.
   *
   * @param WasmPluginLogConfig $logConfig
   */
  public function setLogConfig(WasmPluginLogConfig $logConfig)
  {
    $this->logConfig = $logConfig;
  }
  /**
   * @return WasmPluginLogConfig
   */
  public function getLogConfig()
  {
    return $this->logConfig;
  }
  /**
   * Optional. The ID of the `WasmPluginVersion` resource that is the currently
   * serving one. The version referred to must be a child of this `WasmPlugin`
   * resource.
   *
   * @param string $mainVersionId
   */
  public function setMainVersionId($mainVersionId)
  {
    $this->mainVersionId = $mainVersionId;
  }
  /**
   * @return string
   */
  public function getMainVersionId()
  {
    return $this->mainVersionId;
  }
  /**
   * Identifier. Name of the `WasmPlugin` resource in the following format:
   * `projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}`.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The timestamp when the resource was updated.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Output only. List of all [extensions](https://cloud.google.com/service-
   * extensions/docs/overview) that use this `WasmPlugin` resource.
   *
   * @param WasmPluginUsedBy[] $usedBy
   */
  public function setUsedBy($usedBy)
  {
    $this->usedBy = $usedBy;
  }
  /**
   * @return WasmPluginUsedBy[]
   */
  public function getUsedBy()
  {
    return $this->usedBy;
  }
  /**
   * Optional. All versions of this `WasmPlugin` resource in the key-value
   * format. The key is the resource ID, and the value is the `VersionDetails`
   * object. Lets you create or update a `WasmPlugin` resource and its versions
   * in a single request. When the `main_version_id` field is not empty, it must
   * point to one of the `VersionDetails` objects in the map. If provided in a
   * `PATCH` request, the new versions replace the previous set. Any version
   * omitted from the `versions` field is removed. Because the
   * `WasmPluginVersion` resource is immutable, if a `WasmPluginVersion`
   * resource with the same name already exists and differs, the request fails.
   * Note: In a `GET` request, this field is populated only if the field
   * `GetWasmPluginRequest.view` is set to `WASM_PLUGIN_VIEW_FULL`.
   *
   * @param WasmPluginVersionDetails[] $versions
   */
  public function setVersions($versions)
  {
    $this->versions = $versions;
  }
  /**
   * @return WasmPluginVersionDetails[]
   */
  public function getVersions()
  {
    return $this->versions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WasmPlugin::class, 'Google_Service_NetworkServices_WasmPlugin');
